
;;; - ------------------------------------------------------------------------------ - ;
;;; -                T O O L - A C M - P L S E G I N F O                             - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - Beschreibung : Gibt Informationen ber Segmente von LW/2D/3D-Polylinien aus    - ;
;;; - Befehle      : PLSEGINFO                                                       - ;
;;; - ------------------------------------------------------------------------------ - ;
;;; - letzte nderung am : 20.07.2023                                                - ;
;;; -              durch : Thomas Krger                                             - ;
;;; - ------------------------------------------------------------------------------ - ;
(vl-load-com)
(defun C:PLSEGINFO(/ PL-OBJ VERTEXPROPS DATA PKT
                     DT:UNDOEND DT:UNDOSTART DT:ERROR DT:INIT DT:RESET
                     DT:PL-GET-KOORDS DT:PL-GET-KOORDSX DT:TABLE:ADD
                     OLDDIMZIN
                  )  
  (defun DT:UNDOEND()
    (while(= 8(logand 8 (getvar "undoctl")))
      (vla-endundomark (vla-get-activedocument(vlax-get-acad-object)))
    )      
  )
  (defun DT:UNDOSTART()
    (DT:UNDOEND)
    (vla-startundomark(vla-get-activedocument(vlax-get-acad-object)))
  )
  (defun DT:ERROR (MSG)    
    (if(not(wcmatch(strcase MSG t) "*break,*cancel*,*exit*"))      
      (princ (strcat "\nFEHLER: " MSG))
    )
    (DT:UNDOEND)
    (DT:RESET)
    (princ)
  )
  (defun DT:INIT()
    (DT:UNDOEND)
    (DT:UNDOSTART)        
    (setq ERRORSAVE *error*  *error* DT:ERROR OLDDIMZIN (getvar "DIMZIN"))
    (setvar "DIMZIN" 0)
  )
  (defun DT:RESET()
    (setq *error* ERRORSAVE)
    (setvar "DIMZIN" OLDDIMZIN)
    (mapcar '(lambda(X) (set X nil))(list 'ERRORSAVE 'OLDDIMZIN))
    (DT:UNDOEND)
    (princ)
  )  
  (defun DT:PL-GET-KOORDS ( PL-OBJ / COORDS POINTS)
    (if(and(setq PL-OBJ(cond                                       
                         ((=(type PL-OBJ) 'VLA-OBJECT) PL-OBJ)
                         ((=(type PL-OBJ) 'Ename) (vlax-ename->vla-object PL-OBJ))    
                       )
           )
           (member(strcase(vla-get-Objectname PL-OBJ))         
                   '("ACDB3DPOLYLINE" "ACDBPOLYLINE" "ACDB2DPOLYLINE" "ACDBTRACE")
           )                   
           (setq COORDS(vlax-safearray->list         
                         (vlax-variant-value                
                           (vlax-get-property PL-OBJ 'coordinates)
                         )
                       )      
           ) 
           (cond                           
             ((=(strcase(vla-get-Objectname PL-OBJ))"ACDBPOLYLINE")        
               (repeat (/(length COORDS)2)
                 (setq POINTS(cons(list(car COORDS)(cadr COORDS)0.0) POINTS))
                 (setq COORDS (cddr COORDS))
               )
              POINTS
             )
             ((member(strcase(vla-get-Objectname PL-OBJ))
                     '("ACDB3DPOLYLINE" "ACDB2DPOLYLINE" "ACDBTRACE")
              ) 
               (repeat (/(length COORDS)3)
                 (setq POINTS(cons(list(car COORDS)(cadr COORDS)(caddr COORDS))POINTS))
                 (setq COORDS (cdddr COORDS))
               )
               POINTS
             )  
           )         
       )
      (reverse POINTS)
    )
  )  
  (defun DT:PL-GET-KOORDSX ( PL-OBJ
                           / KOORDS OBJNAME COUNT INDEX VERTEXPROPS BULGE STARTW ENDW
                             GET_R_M
                           )
    (defun GET_R_M( BULGE PRE SUF / W C S R M)
      (if(> (abs BULGE) 0)
        (progn
          (setq W (* 4.0 (atan (abs BULGE)))) 
          (setq C (distance PRE SUF))           
          (setq S (*(/ C 2.0)(abs BULGE)))
          (setq R  (/ (/ C 2.0) (sin (/ W 2.0))))      
          (setq M (polar
                    PRE
                    (if (>= BULGE 0)
                      (+ (angle PRE SUF) (/ (- pi W) 2.0))
                      (- (angle PRE SUF) (/ (- pi W) 2.0))
                    )
                    R
                  )
          )
        )
        (progn(setq R "-")(setq M "-"))
      )
      (list R M)
    )    
    (if(and(setq PL-OBJ(cond
                         ((=(type PL-OBJ) 'VLA-OBJECT) PL-OBJ)
                         ((=(type PL-OBJ) 'Ename) (vlax-ename->vla-object PL-OBJ))    
                       )
           )
           (setq KOORDS (DT:PL-GET-KOORDS PL-OBJ))
           (setq OBJNAME(strcase(vla-get-ObjectName PL-OBJ)))         
           (setq COUNT(length KOORDS))
       )        
      
      (cond
        ((= OBJNAME "ACDBPOLYLINE")
          (setq INDEX -1)
          (repeat (if(=(vla-get-closed PL-OBJ):vlax-true)COUNT(1- COUNT))
            (setq INDEX(1+ INDEX))
            (setq VERTEXPROPS
              (cons
                (list
                  (1+ INDEX)                                             
                  (setq PRE(nth INDEX KOORDS))                                   
                  (if(< INDEX (1- COUNT))
                    (setq SUF(nth (1+ INDEX) KOORDS))
                    (setq SUF(nth 0          KOORDS))
                  )
                  (if(< INDEX (1- COUNT))
                    (setq L 
                      (-(vlax-curve-getDistAtPOINT  PL-OBJ SUF)
                        (vlax-curve-getDistAtPOINT  PL-OBJ PRE)
                      )
                    )
                    (setq L
                      (-(vlax-curve-getDistAtParam PL-OBJ
                          (vlax-curve-getendparam PL-OBJ)
                        )
                        (vlax-curve-getDistAtPOINT  PL-OBJ PRE)
                      )
                    )
                  )
                  (if(not(vl-catch-all-error-p
                           (setq BULGE (vl-catch-all-apply
                                         'vla-GetBulge (list PL-OBJ INDEX)
                                       )
                           )
                         )
                     ) 
                    BULGE
                    0
                  )
                  (GET_R_M BULGE PRE SUF)
                  (if(not(vl-catch-all-error-p
                           (vl-catch-all-apply
                            'vla-GetWidth (list PL-OBJ INDEX 'STARTW 'ENDW)
                           )
                         )
                     ) 
                    (list STARTW ENDW)
                    '(0 0)
                  )
                )  
                VERTEXPROPS
              )
            )
          )
          (setq VERTEXPROPS(reverse VERTEXPROPS))
        )
        ((or(and(= OBJNAME "ACDB2DPOLYLINE")
                (=(vla-get-type PL-OBJ)0)
            )
            (prompt "\nNicht fr angeglichene Polylinien!Abbruch!")
         )
          (setq ENAME (vlax-vla-object->ename PL-OBJ))
          (setq INDEX -1)
          (repeat (if(=(vla-get-closed PL-OBJ):vlax-true)COUNT(1- COUNT))
            (setq INDEX(1+ INDEX))
            (setq VERTEXPROPS
              (cons
                (list
                  (1+ INDEX)                                              
                  (setq PRE(nth INDEX KOORDS))                   
                  (if(< INDEX (1- COUNT))
                    (setq SUF(nth (1+ INDEX) KOORDS))
                    (setq SUF(nth 0          KOORDS))
                   )
                   (if(< INDEX (1- COUNT))
                     (setq L                                                
                       (-(vlax-curve-getDistAtPOINT  PL-OBJ SUF)
                         (vlax-curve-getDistAtPOINT  PL-OBJ PRE)
                       )
                     )
                     (setq L
                       (-(vlax-curve-getDistAtParam PL-OBJ
                           (vlax-curve-getendparam PL-OBJ)
                         )
                         (vlax-curve-getDistAtPOINT  PL-OBJ PRE)
                       )
                     )
                   )
                   (if(and(setq ENAME(entnext ENAME))
                          (=(cdr(assoc 0 (setq OBJDATA(entget ENAME))))"VERTEX")
                       )
                     (setq BULGE(cdr(assoc 42 OBJDATA)))
                     0.0
                   )
                   (GET_R_M BULGE PRE SUF)
                   (if OBJDATA   
                     (list (cdr(assoc 40 OBJDATA))(cdr(assoc 41 OBJDATA)))
                     '(0.0 0.0)
                   )                                                
                 )
                 VERTEXPROPS     
              )
            )
          )
          (setq VERTEXPROPS(reverse VERTEXPROPS))
        ) 
        ((= OBJNAME "ACDB3DPOLYLINE")
          (setq INDEX -1)
          (repeat (if(=(vla-get-closed PL-OBJ):vlax-true)COUNT(1- COUNT))
            (setq INDEX(1+ INDEX))
            (setq VERTEXPROPS
              (cons
                (list
                  (1+ INDEX)  
                  (setq PRE(nth INDEX KOORDS))
                  (if (= INDEX (- COUNT 1))
                    (setq SUF(nth 0 KOORDS)) 
                    (setq SUF(nth (1+ INDEX) KOORDS))
                  )
                  (setq L (distance PRE SUF)) 
                  0
                  '("-""-")
                  '(0 0)                
                )  
                VERTEXPROPS
              )
            )
          )
          (setq VERTEXPROPS(reverse VERTEXPROPS))
        )
      )      
    )      
  )
  (defun DT:TABLE:ADD(PKT TITEL DATA EC? / TABSTYLE H B TXSTYLE TS DIF I J TABOBJ)
    (setq TABSTYLE
      (vlax-ename->vla-object
        (cdr(assoc -1(dictsearch
                       (cdr (assoc -1 (dictsearch (namedobjdict) "acad_tablestyle")))
                       (getvar 'ctablestyle)
                     )
            )
        )
      )
    )
    (setq H(vla-gettextheight TABSTYLE acdatarow))
    (setq TXSTYLE (vla-gettextstyle TABSTYLE acdatarow))
    (if(and(setq TS (tblobjname "style" TXSTYLE))
           (setq TS (cadr (assoc -3 (entget TS '("AcadAnnotative")))))
           (= 1 (cdr (assoc 1070 (reverse TS))))
       )
      (setq H (/ H (cond ((getvar 'cannoscalevalue)) (1.0))))
    )
    (setq B(mapcar
            '(lambda(X)
               (apply 'max
                 (mapcar '(lambda(Z)
                           ((lambda(Y)(if Y (+(* 2.5 H)(-(caadr Y)(caar Y)))0.0))
                             (textbox(list(cons 01 Z)(cons 40 H)(cons 07 TXSTYLE)))
                           )
                          )
                          X
                 )
               )
             )
             (apply 'mapcar(cons 'list DATA))
           )
    )
    (if(and TITEL
            (< 0.0(setq DIF(/(-((lambda(X)(if X(+(* 2.5 H)(-(caadr X)(caar X)))0.0))
                                 (textbox(list(cons 01 TITEL)(cons 40 H)(cons 07 TXSTYLE)))
                               )
                               (apply '+ B)
                             )
                             (length B)
                           )
                  )
            )
       )
      (setq B (mapcar'(lambda(x)(+ X DIF))B))
    )
    (setq TABOBJ
      (vla-addtable
        (if(=(vla-get-activespace(vla-get-activedocument(vlax-get-acad-object)))1)
          (vla-get-modelspace(vla-get-activedocument(vlax-get-acad-object)))
          (vla-get-paperspace(vla-get-activedocument(vlax-get-acad-object)))
        )
        (vlax-3D-point PKT)
        (1+(length DATA))
        (length (car DATA))
        (* 2.0 H)
        (if EC?(apply'max B)(/(apply '+ B)(float(length(car DATA)))))
      )
    )
    (vla-put-regeneratetablesuppressed TABOBJ :vlax-true)
    (vla-put-stylename TABOBJ (getvar 'ctablestyle))
    (setq I -1)  
    (if(null EC?)(foreach SPALTE B (vla-setcolumnwidth TABOBJ (setq I(1+ I))SPALTE)))
    (if TITEL
      (progn(vla-settext TABOBJ 0 0 TITEL)(setq I 1))
      (progn(vla-deleterows TABOBJ 0 1)   (setq I 0))
    )    
    (foreach ZEILE DATA       
       (setq J 0)
       (foreach WERT ZEILE(vla-settext TABOBJ I J  WERT)(setq J (1+ J)))
       (setq I (1+ I)) 
    )
    (vla-put-regeneratetablesuppressed TABOBJ :vlax-false)
    TABOBJ
  )
   
  (DT:INIT) 
  (if(and(or(setq PL-OBJ(car(entsel "\nPolylinie whlen : ")))
            (prompt "\nNichts gewhlt.Abbruch!")
         )
         (or(setq VERTEXPROPS(DT:PL-GET-KOORDSX  PL-OBJ))
            (prompt "\nKeine gltige Polylinie gewhlt.Abbruch!")
         )           
         (setq DATA
           (mapcar
             '(lambda(X / D)
               (list
                 (itoa (car X))
                 (strcat "(" (rtos (car  (cadr  X))2 3 )
                         " " (rtos (cadr (cadr  X))2 3 )
                         " " (rtos (caddr(cadr  X))2 3 )
                         ")"
                 )
                 (strcat "(" (rtos (car  (caddr X))2 3 )
                         " " (rtos (cadr (caddr X))2 3 )
                         " " (rtos (caddr(caddr X))2 3 )
                         ")"
                 )
                 (rtos (nth 3 X)2 3 )
                 (if(=(type(setq D(car(nth 5 X))))'STR)D(rtos D 2 3 ))
                 (if(=(type(setq D(cadr(nth 5 X))))'STR) D
                   (strcat "(" (rtos (car   D)2 3 )
                           " " (rtos (cadr  D)2 3 )
                           " " (rtos (caddr D)2 3 )
                           ")"
                   )
                 )  
                 (rtos (car (nth 6 X))2 3 )
                 (rtos (cadr(nth 6 X))2 3 )
               )
             )  
            VERTEXPROPS
          )
        )
        (setq DATA (cons (list "Segment-NR" "Startpunkt" "Endpunkt"
                               "Lnge" "Radius" "BogenMP" "Stratbreite" "Endbreite"
                         )
                         DATA
                   )
        )
        (or(setq PKT(getpoint"\nEinfgepunkt fr Tabelle <(0 0 0>: "))(setq PKT '(0 0 0)))          
    )
    (DT:TABLE:ADD PKT "PL-INFO" DATA nil)
  )
  (DT:RESET)
)
;;; - ------------------------------------------------------------------------------- - ;
(defun ACM-PLSEGINFO:INFO() 
  (mapcar
    'princ
    (list
      "\n\n"
      "\nACM-PLSEGINFO  : Gibt Informationen ber Segmente von LW/2D/3D-Polylinien aus"
      "\n============== "
      "\n(C) Thomas Krger 2023 (tk@cad-od.de)"
      "\nBefehlszeilenaufrufe : PLSEGINFO\n"
      "\n"    
    )
  )
  (princ)  
)
;;; - ------------------------------------------------------------------------------ - ;
(ACM-PLSEGINFO:INFO)
(princ)
                   

